<?php
/*
    Build-a-map : creating maps from maps
    Copyright (C) 2009, askywhale.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
    index.php : main script
*/
?>

<html><head></head><body>
<?php

define("IN_FILENAME","source.gif"); //gif image, see documentation website
define("OUT_FILENAME","result.png"); //png image created here 
define("OUT_TX",200); // 1.., width of the result image
define("OUT_TY",140); // 1.., height of the result image
define("MLT",1.2); //1.., float ; aliasing is better with high value (3, 4), but memory....
define("HIGHPASS_LEVEL",1.2); //1.., float ; high-pass filter (sharpen), none = 1
define("DEFORMATION_RATIO",1); //0 if no need, 1 if from full mercator projection
define("DEFORMATION_NOT_CROPPED",.8); //0..1 prc of the map not cropped in the source
define("DEFORMATION_EQUATOR",.6); //0..1 prc of the map above equator

define("MEMORY_LIMIT_MB",floor(8+OUT_TX*OUT_TY*MLT*MLT*82/1e6));
define("I_TX",floor(OUT_TX*MLT));
define("I_TY",floor(OUT_TY*MLT));

ini_set('memory_limit',MEMORY_LIMIT_MB.'M'); //WARN quite high
ini_set('max_execution_time',12*3600); //WARN 6 hours

//r, g, b: 0..255, v : -255..+255 
function lighten(&$r, &$g, &$b, $v) {
  if($v>0) {
    $iv = 255-$v;
    $r = ($r * $iv + 255 * $v)>>8;
    $g = ($g * $iv + 255 * $v)>>8;
    $b = ($b * $iv + 255 * $v)>>8;
  } else {
    $pv = 255+$v;
    $r = ($r * $pv)>>8;
    $g = ($g * $pv)>>8;
    $b = ($b * $pv)>>8;
  }
} 

function getDt($n, $ndt) {
  return ($n>>($ndt*8)) & 255;
} 
  
function setDt(& $n, $ndt, $v) {
  $n &= ~(255<<($ndt*8));
  $n += ($v & 255)<<($ndt*8);
  return $v;
}

function cubicConv($distance, & $f ) {
 return ( -$f[0] + $f[1] - $f[2] + $f[3]) * $distance*$distance*$distance
  + (2.0*$f[0] - 2.0*$f[1] + $f[2] - $f[3]) * $distance*$distance
  + ( -$f[0] + $f[2] ) * $distance
  + $f[1] ;
}

function imagecopybicubic(& $im_dst, & $im_src, $tx_dst, $ty_dst, $tx_src, $ty_src) {
  $mlt_x = round($tx_src/$tx_dst,4);
  $mlt_y = round($ty_src/$ty_dst,4);
  $bxt = array();
  $dxt = array();
  for($x=0;$x<$tx_dst;$x++) {
    $bxt[$x] = floor($x*$mlt_x);
    $dxt[$x] = $x*$mlt_x-$bxt[$x];  
  }
  $byt = array();
  $dyt = array();
  for($y=0;$y<$ty_dst;$y++) {
    $byt[$y] = floor($y*$mlt_y);
    $dyt[$y] = $y*$mlt_y-$byt[$y];  
  }
  for($x=0;$x<$tx_dst;$x++) {
    $bx = $bxt[$x];
    $dx = $dxt[$x];
    for($y=0;$y<$ty_dst;$y++) {  
      $by = $byt[$y];
      $dy = $dyt[$y];
      $pc = array();
      for($xx = 0;$xx<4;$xx++) {
        $x2 = $bx-1+$xx;
        for($yy = 0;$yy<4;$yy++) {          
          $y2 = $by-1+$yy;
          if($x2<0||$x2>=$tx_src||$y2<0||$y2>=$ty_src)
            $pc[$xx][$yy] = array('red'=>255,'green'=>255,'blue'=>255);
          else
            $pc[$xx][$yy] = 
              imagecolorsforindex($im_src, imagecolorat($im_src, $x2, $y2));        
        }
      }      
      $c = array();
      foreach(array('red','green','blue') as $n=>$cname) {
        $cxx = array();       
        for($xx = 0;$xx<4;$xx++) {
          $cyy = array();          
          for($yy = 0;$yy<4;$yy++)
            $cyy[] = $pc[$xx][$yy][$cname];
          $cxx[] = cubicConv($dy,$cyy);
          unset($cyy);
        }
        $c[$n] = floor(cubicConv($dx,$cxx));
        unset($cxx);         
      }
      unset($pc);
      imagesetpixel($im_dst,$x,$y,imagecolorallocate($im_dst,
        min(255,max(0,$c[0])),
        min(255,max(0,$c[1])),
        min(255,max(0,$c[2]))));
      unset($c);
    }
  }
}

function showTime($who="?",$info=""){
  global $last_time, $total_time;
  $now = microtime(true);
  if(!isset($last_time) || $last_time==0)
    $last_time = $now;
  $total_time += $now-$last_time;
  echo sprintf("%s INFO %.2fs %.2fs %4dMo %s<br>",$who,$now-$last_time,$total_time,
    memory_get_usage(true)/1e6,$info);
  $last_time = $now;    
}

showTime(__FILE__.":".__LINE__,"start, will allocate up to ".MEMORY_LIMIT_MB." MB");
$im_in = imagecreatefromgif(IN_FILENAME);
$im = imagecreate(I_TX,I_TY);
imagecopyresized($im,$im_in,0,0,0,0,I_TX,I_TY,imagesx($im_in),imagesy($im_in));
imagedestroy($im_in);

$t = array(); //memory optimisation (/4) : all in one array, 1 byte per data
$back_color = imagecolorat($im,0,0);
$equator = floor(I_TY*DEFORMATION_EQUATOR);
for($x=0;$x<I_TX;$x++)
  for($y=0;$y<I_TY;$y++) {
    if(DEFORMATION_RATIO>0) {
      if($y>$equator)
        $sy2 = floor($equator+(I_TY-$equator)*
          asin(DEFORMATION_NOT_CROPPED*($y-$equator)/(I_TY-$equator))/
          asin(DEFORMATION_NOT_CROPPED));
      else 
        $sy2 = floor($equator-$equator*
          asin(DEFORMATION_NOT_CROPPED*($equator-$y)/$equator)/
          asin(DEFORMATION_NOT_CROPPED));
      $sy = floor((1-DEFORMATION_RATIO)*$sy+DEFORMATION_RATIO*$sy2);
    }
    $c = imagecolorat($im,$x,$y);
    if($c==$back_color)
      $c = 0;
    else if($c<$back_color)
      $c +=1;
    $t[$x][$y] = $c;
    //5 on 8 or 3 on 4 equals : change for it
    if($x>1 && $y>1 && $x<I_TX-1 && $y<I_TY-1) {
      unset($cols);
      $cols = array();
      for($x2=$x-1;$x2<=$x+1;$x2++)
        for($y2=$y-1;$y2<=$y+1;$y2++) 
          if($x2!=$x ||$y2 != $y) {
            $cols[$t[$x2][$y2]]++;
            if($cols[$t[$x2][$y2]]==5)
              $t[$x][$y] = $t[$x2][$y2];            
          }
      unset($cols);
      $cols = array();
      if($x>1 && $y>1 && $x<I_TX-1 && $y<I_TY-1) {
        for($x2=$x-1;$x2<=$x+1;$x2++)
          for($y2=$y-1;$y2<=$y+1;$y2++) 
            if(($x2!=$x) ^ ($y2 != $y)) {
              $cols[$t[$x2][$y2]]++;
              if($cols[$t[$x2][$y2]]==3)
                $t[$x][$y] = $t[$x2][$y2];            
            }
      }            
    }    
  }

showTime(__FILE__.":".__LINE__);

imagedestroy($im);
  
$dtname = array(1=>"side",2=>"sea",3=>"ter");

showTime(__FILE__.":".__LINE__);

for($x=0;$x<I_TX;$x++)
  for($y=0;$y<I_TY;$y++) {
    foreach($dtname as $ndt=>$unu)
      setDt($t[$x][$y],$ndt,255);
    if($x==0 || $x==I_TX-1 || $y==0 || $y==I_TY-1 )
      setDt($t[$x][$y],1,0); //side
    if(($x<I_TX-1 && getDt($t[$x][$y],0)!=getDt($t[$x+1][$y],0)) ||  
        ($y<I_TY-1 && getDt($t[$x][$y],0)!=getDt($t[$x][$y+1],0))) 
      if(getDt($t[$x][$y],0)==0 || 
          ($x<I_TX-1 && getDt($t[$x+1][$y],0)==0) || 
          ($y<I_TY-1 && getDt($t[$x][$y+1],0)==0))
        setDt($t[$x][$y],2,0); //sea
      else
        setDt($t[$x][$y],3,0); //ter
  } 


$nbit = 2+sqrt(I_TX*I_TY)/1000;
showTime(__FILE__.":".__LINE__,"Process with ".floor($nbit)." iterations");
foreach($dtname as $ndt=>$tname) {
  for($i=0;$i<$nbit;$i++){
    for($x=0;$x<I_TX;$x++)
      for($y=0;$y<I_TY;$y++) {
        $dtc = getDt($t[$x][$y],$ndt);
        if($x>0) {
          $d2 = getDt($t[$x-1][$y],$ndt)+2;
          if($d2<$dtc)
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($y>0) {
          $d2 = getDt($t[$x][$y-1],$ndt)+2;
          if($d2<$dtc)          
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($x>0 && $y>0) {
          $d2 = getDt($t[$x-1][$y-1],$ndt)+3;
          if($d2<$dtc)
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($x>0 && $y<I_TY-1) {
          $d2 = getDt($t[$x-1][$y+1],$ndt)+3;
          if($d2<$dtc)
            setDt($t[$x][$y],$ndt,$d2);
        }      
      }
    for($x=I_TX-1;$x>=0;$x--)
      for($y=I_TY-1;$y>=0;$y--) {
        $dtc = getDt($t[$x][$y],$ndt);
        if($x<I_TX-1){
          $d2 = getDt($t[$x+1][$y],$ndt)+2;
          if($d2<$dtc)
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($y<I_TY-1){
          $d2 = getDt($t[$x][$y+1],$ndt)+2;
          if($d2<$dtc)
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($x<I_TX-1 && $y<I_TY-1){
          $d2 = getDt($t[$x+1][$y+1],$ndt)+3;
          if($d2<$dtc)
            $dtc = setDt($t[$x][$y],$ndt,$d2);
        }
        if($x<I_TX-1 && $y>0){
          $d2 = getDt($t[$x+1][$y-1],$ndt)+3;
          if($d2<$dtc)
            setDt($t[$x][$y],$ndt,$d2);
        }      
      }
  }
}

showTime(__FILE__.":".__LINE__);

$im = imagecreatetruecolor(I_TX,I_TY);
for($x=0;$x<I_TX;$x++)
  for($y=0;$y<I_TY;$y++) {
    $dom = getDt($t[$x][$y],0);
    $v = array();
    foreach($dtname as $ndt=>$tname) 
      $v[$tname] = getDt($t[$x][$y],$ndt);
    if($v['ter']==0 || $v['sea']==0){
      $r = 120; $g = 120; $b = 80; 
    } elseif($dom==0) { //sea
      $r = 180; 
      $g = 220 - 20*abs($y-I_TY/2)/(I_TX); 
      $b = 255;
      $d = 12 * 
        ((sin($x*19./(I_TX))*cos($y*17./(I_TY))) + 
        (sin($x*6./(I_TX))*cos($y*11./(I_TY))) + 
        (sin($x*9./(I_TX))*cos($y*4./(I_TY))));
      lighten($r,$g,$b,$d);
    } else {
      $r = 180+(($dom*13)%40);
      $g = 200+(($dom*29)%50);
      $b = 180;
    }
    $limit = array('side'=>min(255,8+I_TX/60),
      'ter'=>min(255,8+I_TX/60),
      'sea'=>min(255,16+I_TX/30));
    if($v['side']<$limit['side'])
      lighten($r,$g,$b,pow(($limit['side']-$v['side'])/$limit['side'],2)*255);
    if(($v['ter']>1 && $v['ter']<=$limit['ter']))
      lighten($r,$g,$b,-pow(($limit['ter']-$v['ter']+1)/$limit['ter'],2)*30);
    if($v['sea']>1 && $v['sea']<=$limit['ter'] && $dom>0)
      lighten($r,$g,$b,-pow(($limit['ter']-$v['sea']+1)/$limit['ter'],2)*30);
    if($v['sea']>1 && $v['sea']<=$limit['sea'] && $dom==0)
      lighten($r,$g,$b,pow(($limit['sea']-$v['sea']+1)/$limit['sea'],2)*100);
    imagesetpixel($im,$x,$y,imagecolorallocate($im,$r,$g,$b));
  }

unset($t);

showTime(__FILE__.":".__LINE__);

imagepng($im,"pre_".OUT_FILENAME);

/* supersampling and interpolation
ex : MLT = 3.5 : 
  bicubic interpolation ($bic_mlt = 1.66)
  then superampling ($ss_mlt=3) 
*/

$bic_mlt = floor(MLT);
if($bic_mlt==MLT) 
  $im_post_int = & $im;
else {
  $im_post_int = imagecreatetruecolor(floor(OUT_TX*$bic_mlt),floor(OUT_TY*$bic_mlt));
  imagecopybicubic($im_post_int,$im,floor(OUT_TX*$bic_mlt),floor(OUT_TY*$bic_mlt),
    floor(OUT_TX*MLT),floor(OUT_TY*MLT));
  imagedestroy($im);
  unset($im);
}

if($bic_mlt==1) {
  $im_post_ss = & $im_post_int;
} else {//supersampling needed
  $im_post_ss = imagecreatetruecolor(OUT_TX,OUT_TY);
  for($x=0;$x<OUT_TX;$x++)
    for($y=0;$y<OUT_TY;$y++) {
      $r = $g = $b = $n = 0;
      for($x2=$x*$bic_mlt;$x2<($x+1)*$bic_mlt;$x2++)
        for($y2=$y*$bic_mlt;$y2<($y+1)*$bic_mlt;$y2++) {
          $c = imagecolorsforindex($im_post_int, imagecolorat($im_post_int, $x2, $y2));      
          $r += $c['red'];
          $g += $c['green'];
          $b += $c['blue'];
          $n++;      
        }      
      imagesetpixel($im_post_ss,$x,$y,imagecolorallocate($im_post_ss,
        floor($r/$n),floor($g/$n),floor($b/$n)));
    }
  imagedestroy($im_post_int);
  unset($im_post_int);
}

if(HIGHPASS_LEVEL==1) {
  $im_post_hp = & $im_post_ss;
} else {//highpass filter wanted
  $im_post_hp = imagecreatetruecolor(OUT_TX,OUT_TY);
  $mlt = (1-HIGHPASS_LEVEL)*.25;
  for($x=0;$x<OUT_TX;$x++)
    for($y=0;$y<OUT_TY;$y++) {
      $c = imagecolorsforindex($im_post_ss, imagecolorat($im_post_ss, $x, $y));
      $r = $c['red'] * HIGHPASS_LEVEL;
      $g = $c['green'] * HIGHPASS_LEVEL;
      $b = $c['blue'] * HIGHPASS_LEVEL;
      if($x>0&&$y>0&&$x<OUT_TX-1&&$y<OUT_TY-1) {
        for($x2=$x-1;$x2<=$x+1;$x2++)
          for($y2=$y-1;$y2<=$y+1;$y2++) 
            if($x2==$x ^ $y2==$y) {
              $c = imagecolorsforindex($im_post_ss, imagecolorat($im_post_ss, $x2, $y2));
              $r += $c['red'] * $mlt;
              $g += $c['green'] * $mlt;
              $b += $c['blue'] * $mlt;
              unset($c);
            }
        $r = min(255,max(0,floor($r)));
        $g = min(255,max(0,floor($g)));
        $b = min(255,max(0,floor($b)));
      }
      imagesetpixel($im_post_hp,$x,$y,imagecolorallocate($im_post_hp,$r,$g,$b));
    }  
  imagedestroy($im_post_ss);
  unset($im_post_ss);
}

$im_out = & $im_post_hp;
imagepng($im_out,OUT_FILENAME);    
imagedestroy($im_out);
unset($im_out);

showTime(__FILE__.":".__LINE__,"end, max memory used : ".memory_get_peak_usage (true));

echo "Result below<br /><a href='".OUT_FILENAME."'><img src='".OUT_FILENAME."' /></a>";

?>
</body></html>
